procedure $see_contx
argument local string scalar runno
argument local namelist freqs
argument local numeric series by case agelower = list(16,25,16,16,16,18,20,25,25,30,35,40,45,50,55,55,60,62,65,70)
argument local numeric series by case ageupper = list(80,80,19,24,17,19,24,54,29,34,39,44,49,54,80,59,61,64,69,80)
argument local string scalar db_path = ""
block

   thickness medium 3
   thickness thick 10

   legend contents description off 
   legend size small

   map color postscript C1  "black", c2  "blue", C3 "red", C4 "green", c5 "darkmagenta", &&
                        C6 "#707070", C7 "gold", C8 "seagreen", C9 "hotpink", c10 "darkturquoise", &&
                        C11 "burlywood", C12 "brown", C13 "tomato", c14 "lightsteelblue", c15 "#d9d9d9", &&
                        c16 "Lemonchiffon"

   plot color #1 c1, #2 c2, #3 c3, #4 c4, #5 c5, &&
              #6 c6, #7 c7, #8 c8, #9 c9, #10 c10, &&
              #11 c11, #12 c12, #13 c13, #14 c14
   plot style solid


   if missing(location(@open.db,"LOUT"))
      open <ac re> file(local'db_path+"lfpr_run"+local'runno+".db") as lout
      -local'loutopened = TRUE
   else
      -local'loutopened = FALSE
   end if

   if missing(location(@open.db,"CPSREV"))
      open <ac re> file(local'db_path+"cpscovar_rev.db") as cpsrev
      -local'cpsrevopened = TRUE
   else
      -local'cpsrevopened = FALSE
   end if

   if missing(location(@open.db,"LFPRIN"))
      open <ac re> file(local'db_path+"input.db") as lfprin
      -local'linopened = TRUE
   else
      -local'linopened = FALSE
   end if

   device graphics postp
   legend size small, fill horizontal
   legend division rows auto, column 5
   legend color black
   thickness thick 15
   page title area length standard
   page title #1 right size xsmall, text datefmt(lout'runtime), color c1, font f10

   loop for sfreq in freqs
      execute "freq "+name(sfreq)
      -local'ssfreq = (if name(sfreq) eq "M" then "" else name(sfreq))
      -local'q3 = make(date,"1976:"+(if name(sfreq) eq "M" then "1" else "1"))

      open <ac over; kind graphic> file("run"+local'runno+"cont_"+name(sfreq)+".ps") as contout
      channel graphics contout

      page division rows 4, columns 2
      loop for GG in {m,f}
         loop for AA = 16 to 79
            -local'lo_lfpr&GG&_a&AA&sfreq = log(cpsrev'id(lout'lfpname)&GG&_a&AA&id(ssfreq)/(1-cpsrev'id(lout'lfpname)&GG&_a&AA&id(ssfreq)))
            -local'ostr = "data 100*lout'"+lout'lfpname+"_pred"+name(GG)+string(AA)+name(sfreq)+" <plot color c15, thickness thick, name ""Fitted"">"
            -local'cstr = "data "
            -local'fit&GG&AA&sfreq = lout'id(lout'lfpname)&_pred&GG&AA&sfreq
            -local'lofit&GG&AA&sfreq = log(local'fit&GG&AA&sfreq/(1-local'fit&GG&AA&sfreq))
            -local'sep = ""
            loop for i=1 to lastvalue(lout'vars)
               if exists(lout'id(lout'vars[i])&c&GG&AA&sfreq)
                  date * to *
                  if lout'vartype[i] eq 0 or lout'vartype[i] eq 2
                     -local'var = lfprin'id(lout'vars[i])&_&sfreq
                  else if lout'vartype[i] eq 1 or lout'vartype[i] eq 3
                     -local'var = lfprin'id(lout'vars[i])&_a&AA&_&sfreq
                  else if lout'vartype[i] eq 4 or lout'vartype[i] eq 6
                     -local'var = lfprin'id(lout'vars[i])&_a&AA&GG&_&sfreq
                  else if lout'vartype[i] eq 5
                     -local'var = lfprin'id(lout'vars[i])&_&GG&_&sfreq
                  end if
                  if lout'varnorm[i] eq 1
                     date 1976:1 to *
                     which not missing(local'var)
                     -local'offset = -lout'id(lout'vars[i])&c&GG&AA&sfreq*ave(local'var)/stddev(local'var)
                     -local'nvar = (local'var-ave(local'var))/stddev(local'var) 
                     date * to *
                  else
                     -local'nvar = local'var
                     -local'offset = 0
                  end if

                  -local'contv&i&GG&AA&sfreq = lout'id(lout'vars[i])&c&GG&AA&sfreq*local'nvar
                  if lout'varcyc[i] ne 1
                     -local'offset = local'contv&i&GG&AA&sfreq[1976:1]
                  end if

                  -local'lofitv&i&GG&AA&sfreq = local'lofit&GG&AA&sfreq-local'contv&i&GG&AA&sfreq+local'offset                                      
                  -local'fitv&i&GG&AA&sfreq = 100/(exp(-local'lofitv&i&GG&AA&sfreq)+1)
                  -local'ccv&i&GG&AA&sfreq = 100*lout'id(lout'lfpname)&_pred&GG&AA&sfreq-local'fitv&i&GG&AA&sfreq

                  set local'cstr = local'cstr+local'sep+"local'ccv"+string(i)+name(GG)+string(AA)+name(sfreq)+ &&
                                   "<plot color c"+string(i+1)+",name """+lout'vars[i]+""", thickness xthin>"              
                  set local'ostr = local'ostr+",local'fitv"+string(i)+name(GG)+string(AA)+name(sfreq)+ &&
                                   "<plot color c"+string(i+1)+",name """+lout'vars[i]+""", thickness xthin>"              
                  if local'sep eq ""; -local'sep =  ","; end if
               end if
            end loop   

            graph
               order 4; order region 1,lines 2, markings 3, series 5
               title #1 center size small, text "Fitted and Conterfactual Aggregate LFPR (" + (if name(GG) EQ "M" then "Male" else "Female")  + ", Age "+string(AA)+")"
               date 1976 to *
               execute local'ostr
               draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            end graph

            graph
               order 4; order region 1,lines 2, markings 3, series 5
               title #1 center size small, text "Contributions (" + (if name(GG) EQ "M" then "Male" else "Female")  + ", Age "+string(AA)+")"
               date 1976 to *
               execute local'cstr
               draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            end graph
         end loop
         refresh
      end loop
      close contout
      execute "!(ps2pdf run"+local'runno+"cont_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"cont_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"cont_"+name(sfreq)+".ps)&"

      -- AGGREGATE UP THE CONTRIBUTIONS INTO AGE GROUPS
      case 1 to *

      open <ac over; kind graphic> file("run"+local'runno+"cont2_"+name(sfreq)+".ps") as cont2out
      channel graphics cont2out

      page division rows 3, column 1
      loop for GG in {m,f}
         loop for i=1 to lastvalue(local'agelower) -- group loop
            -local'grpvar = string(local'agelower[i])+(if local'ageupper[i] eq 80 then "p" else ("t"+string(local'ageupper[i])))

            date lout'start_est&"."&sfreq to lout'end_frcst&"."&sfreq
            -local'act&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'act_alt&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'act_alt2&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'agg&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'ab&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'ab2&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'pop&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'pb&GG&id(local'grpvar)&sfreq = series(0d0)
            -local'astr = "data local'agg"+name(GG)+local'grpvar+name(sfreq)+" <plot color c15, thickness thick, name ""Fitted"">,"+ &&
                               "local'ab"+name(GG)+local'grpvar+name(sfreq)+" <plot color black, thickness thin, name ""Population"">,"+ &&
                               "local'ab2"+name(GG)+local'grpvar+name(sfreq)+" <plot color black, thickness thin, style dashed, name ""Population Alt"">,"
            -local'dstr = "data "        

            loop for a = local'agelower[i] to local'ageupper[i]
               if a eq 80
                  set local'act&GG&id(local'grpvar)&sfreq = local'act&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)               
                  set local'act_alt&GG&id(local'grpvar)&sfreq = local'act_alt&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)[local'q3]
                  set local'act_alt2&GG&id(local'grpvar)&sfreq = local'act_alt2&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)[local'q3]*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                  set local'agg&GG&id(local'grpvar)&sfreq = local'agg&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                  set local'ab&GG&id(local'grpvar)&sfreq = local'ab&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)[local'q3]
                  set local'ab2&GG&id(local'grpvar)&sfreq = local'ab2&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)[local'q3]*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
               else
                  set local'act&GG&id(local'grpvar)&sfreq = local'act&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a"+string(a)+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)               
                  set local'act_alt&GG&id(local'grpvar)&sfreq = local'act_alt&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a"+string(a)+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)[local'q3]
                  set local'act_alt2&GG&id(local'grpvar)&sfreq = local'act_alt2&GG&id(local'grpvar)&sfreq + &&
                        cpsrev'id(lout'lfpname+name(GG)+"_a"+string(a)+local'ssfreq)[local'q3]*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                  set local'agg&GG&id(local'grpvar)&sfreq = local'agg&GG&id(local'grpvar)&sfreq + &&
                        lout'id(lout'lfpname+"_pred"+name(GG)+string(a)+name(sfreq))*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                  set local'ab&GG&id(local'grpvar)&sfreq = local'ab&GG&id(local'grpvar)&sfreq + &&
                        lout'id(lout'lfpname+"_pred"+name(GG)+string(a)+name(sfreq))*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)[local'q3]
                  set local'ab2&GG&id(local'grpvar)&sfreq = local'ab2&GG&id(local'grpvar)&sfreq + &&
                        lout'id(lout'lfpname+"_pred"+name(GG)+string(a)+name(sfreq))[local'q3]*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
               end if
               set local'pop&GG&id(local'grpvar)&sfreq = local'pop&GG&id(local'grpvar)&sfreq + cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
               set local'pb&GG&id(local'grpvar)&sfreq = local'pb&GG&id(local'grpvar)&sfreq + cpsrev'pop&GG&"_a"&a&id(local'ssfreq)[local'q3]
            end loop

            set local'act&GG&id(local'grpvar)&sfreq = 100*local'act&GG&id(local'grpvar)&sfreq/local'pop&GG&id(local'grpvar)&sfreq
            set local'act_alt&GG&id(local'grpvar)&sfreq = 100*local'act_alt&GG&id(local'grpvar)&sfreq/local'pb&GG&id(local'grpvar)&sfreq
            set local'act_alt2&GG&id(local'grpvar)&sfreq = 100*local'act_alt2&GG&id(local'grpvar)&sfreq/local'pop&GG&id(local'grpvar)&sfreq
            set local'agg&GG&id(local'grpvar)&sfreq = 100*local'agg&GG&id(local'grpvar)&sfreq/local'pop&GG&id(local'grpvar)&sfreq
            set local'ab&GG&id(local'grpvar)&sfreq = 100*local'ab&GG&id(local'grpvar)&sfreq/local'pb&GG&id(local'grpvar)&sfreq
            set local'ab2&GG&id(local'grpvar)&sfreq = 100*local'ab2&GG&id(local'grpvar)&sfreq/local'pop&GG&id(local'grpvar)&sfreq

            loop for v=1 to lastvalue(lout'vars)

               -local'aggv&v&GG&id(local'grpvar)&sfreq = series(0d0)

               -local'gotone = 0
               loop for a = local'agelower[i] to local'ageupper[i]
                  if exists(local'fitv&v&GG&a&sfreq)
                     set local'aggv&v&GG&id(local'grpvar)&sfreq = local'aggv&v&GG&id(local'grpvar)&sfreq + &&
                         local'fitv&v&GG&a&sfreq*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                     set local'gotone = 1
                  else 
                     if a eq 80
                        set local'aggv&v&GG&id(local'grpvar)&sfreq = local'aggv&v&GG&id(local'grpvar)&sfreq + &&
                            100*cpsrev'id(lout'lfpname+name(GG)+"_a80"+local'ssfreq)*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                     else
                        set local'aggv&v&GG&id(local'grpvar)&sfreq = local'aggv&v&GG&id(local'grpvar)&sfreq + &&
                            100*lout'id(lout'lfpname)&"_pred"&GG&a&sfreq*cpsrev'pop&GG&"_a"&a&id(local'ssfreq)
                     end if
                  end if
               end loop
               
               if local'gotone eq 1
                  set local'aggv&v&GG&id(local'grpvar)&sfreq = local'aggv&v&GG&id(local'grpvar)&sfreq/local'pop&GG&id(local'grpvar)&sfreq

                  -local'diffv&v&GG&id(local'grpvar)&sfreq = local'agg&GG&id(local'grpvar)&sfreq-local'aggv&v&GG&id(local'grpvar)&sfreq

                  set local'astr = local'astr+"local'aggv"+string(v)+name(GG)+local'grpvar+name(sfreq)+ &&
                                  " <plot color c"+string(v+1)+",name """+lout'vardesc[v]+""", thickness xthin>,"
                  set local'dstr = local'dstr+"local'diffv"+string(v)+name(GG)+local'grpvar+name(sfreq)+ &&
                                  " <plot color c"+string(v+1)+",name """+lout'vardesc[v]+""", thickness xthin>,"
               else
                  delete local'aggv&v&GG&id(local'grpvar)&sfreq
               end if           
            end loop

            graph
               order 4; order region 1,lines 2, markings 3, series 5
               legend division row auto, column 3
               title #1 center size medium, text "Fitted and Counterfactual Aggregate LFPR (" + (if name(GG) EQ "M" then "Male" else "Female")  + ", Ages "+local'grpvar+")"
               date 1976 to *
               execute rtrim(local'astr,",")
               draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            end graph 

            graph
               order 4; order region 1,lines 2, markings 3, series 5
               legend division row auto, column 3
               title #1 center size medium, text "Contributions (" + (if name(GG) EQ "M" then "Male" else "Female")  + ", Ages "+local'grpvar+")"
               date 1976 to *
               execute rtrim(local'dstr,",")
               draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            end graph 

            graph
               order 4; order region 1,lines 2, markings 3, series 5
               -- legend appear off
               title #1 center size small, text "Population Contributions (" + (if name(GG) EQ "M" then "Male" else "Female")  + ", Ages "+local'grpvar+")"
               date 1976 to *
               data (local'agg&GG&id(local'grpvar)&sfreq-local'ab&GG&id(local'grpvar)&sfreq) <plot color black, legend off, thickness thin>, &&
                    (local'ab2&GG&id(local'grpvar)&sfreq-local'agg&GG&id(local'grpvar)&sfreq[local'q3]) <plot color black, style dashed, name "Alt", thickness thin>
               draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
               draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
                  (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
               draw line (firstdate,0) to (lastvalue(local'agg&GG&id(local'grpvar)&sfreq),0)
            end graph 

         end loop
      end loop


      -- aggregates across sex
      loop for i=1 to lastvalue(local'agelower) -- group loop
         -local'grpvar = string(local'agelower[i])+(if local'ageupper[i] eq 80 then "p" else ("t"+string(local'ageupper[i])))
         -local'astr = "data local'agg"+local'grpvar+name(sfreq)+" <plot color c15, thickness thick, name ""Fitted"">,"+ &&
                            "local'ab"+local'grpvar+name(sfreq)+" <plot color black, thickness thin, name ""Population"">,"+ &&
                            "local'ab2"+local'grpvar+name(sfreq)+" <plot color black, style dashed, thickness thin, name ""Alt Population"">,"
         -local'dstr = "data "

         local'act&id(local'grpvar)&sfreq = (local'actm&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                             local'actf&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                            (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
         local'act_alt&id(local'grpvar)&sfreq = (local'act_altm&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                                 local'act_altf&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                                (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
         local'act_alt2&id(local'grpvar)&sfreq = (local'act_alt2m&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                                  local'act_alt2f&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                                 (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
         local'agg&id(local'grpvar)&sfreq = (local'aggm&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                             local'aggf&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                            (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
         local'ab&id(local'grpvar)&sfreq = (local'abm&id(local'grpvar)&sfreq*local'pbm&id(local'grpvar)&sfreq+ &&
                                            local'abf&id(local'grpvar)&sfreq*local'pbf&id(local'grpvar)&sfreq)/ &&
                                           (local'pbm&id(local'grpvar)&sfreq+local'pbf&id(local'grpvar)&sfreq)
         local'ab2&id(local'grpvar)&sfreq = (local'ab2m&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                             local'ab2f&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                            (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
         loop for v=1 to lastvalue(lout'vars)
            -local'gotone = 0
            if (exists(local'aggv&v&m&id(local'grpvar)&sfreq))
               -local'gotone = 1
               if (exists(local'aggv&v&f&id(local'grpvar)&sfreq))
                  -local'aggv&v&id(local'grpvar)&sfreq = (local'aggv&v&m&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                                          local'aggv&v&f&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                                         (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
               else
                  -local'aggv&v&id(local'grpvar)&sfreq = (local'aggv&v&m&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                                          local'aggf&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                                         (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
               end if
            else if (exists(local'aggv&v&f&id(local'grpvar)&sfreq))
               -local'gotone = 1
               -local'aggv&v&id(local'grpvar)&sfreq = (local'aggm&id(local'grpvar)&sfreq*local'popm&id(local'grpvar)&sfreq+ &&
                                                       local'aggv&v&f&id(local'grpvar)&sfreq*local'popf&id(local'grpvar)&sfreq)/ &&
                                                      (local'popm&id(local'grpvar)&sfreq+local'popf&id(local'grpvar)&sfreq)
            end if

            if local'gotone eq 1
               -local'diffv&v&id(local'grpvar)&sfreq = local'agg&id(local'grpvar)&sfreq-local'aggv&v&id(local'grpvar)&sfreq
               description(local'diffv&v&id(local'grpvar)&sfreq) = lout'vars[v]

               set local'astr = local'astr+"local'aggv"+string(v)+local'grpvar+name(sfreq)+ &&
                               " <plot color c"+string(v+1)+",name """+lout'vardesc[v]+""", thickness xthin>,"
               set local'dstr = local'dstr+"local'diffv"+string(v)+local'grpvar+name(sfreq)+ &&
                               " <plot color c"+string(v+1)+",name """+lout'vardesc[v]+""", thickness xthin>,"
            end if
         end loop        
  
         graph
            order 4; order region 1,lines 2, markings 3, series 5
            legend division row auto, column 3
            title #1 center size medium, text "Fitted and Counterfactual Aggregate LFPR (Ages "+local'grpvar+")"
            date 1976 to *
            execute rtrim(local'astr,",")
            draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
         end graph 

         graph
            order 4; order region 1,lines 2, markings 3, series 5
            legend division row auto, column 3
            title #1 center size medium, text "Contributions (Ages "+local'grpvar+")"
            date 1976 to *
            execute rtrim(local'dstr,",")
            draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
         end graph 

         graph
            order 4; order region 1,lines 2, markings 3, series 5
            legend appear off
            title #1 center size small, text "Population Contributions (Ages "+local'grpvar+")"
            date 1976 to *
            data (local'agg&id(local'grpvar)&sfreq-local'ab&id(local'grpvar)&sfreq) <plot color black, thickness thin>, &&
                 (local'ab2&id(local'grpvar)&sfreq-local'agg&id(local'grpvar)&sfreq[local'q3]) <plot color black, style dashed, name "Alt", thickness thin>
            draw region <depict axis bottom, color C16,shading paint; glue dot> lout'end_est&sfreq+1 to lout'end_frcst&sfreq+1
            draw line <depict axis bottom, color C15, placement beginning; glue dot> &&
               (lout'end_est&sfreq+1,@left.axis.min) to (lout'end_est&sfreq+1,@left.axis.max)
            draw line (firstdate,0) to (lastvalue(local'agg&id(local'grpvar)&sfreq),0)
         end graph 

         repo (local'agg&id(local'grpvar)&sfreq-local'ab&id(local'grpvar)&sfreq) as "Pop!Contribution!"+local'grpvar, &&
              (local'ab2&id(local'grpvar)&sfreq-local'agg&id(local'grpvar)&sfreq[local'q3]) as "Alt!Pop!Contribution!"+local'grpvar, &&
              (local'act&id(local'grpvar)&sfreq-local'act_alt&id(local'grpvar)&sfreq) as "Act Pop!Contribution!"+local'grpvar, &&
              (local'act_alt2&id(local'grpvar)&sfreq-local'act&id(local'grpvar)&sfreq[local'q3]) as "Act Pop!Alt!Contribution!"+local'grpvar
      end loop

      close cont2out
      execute "!(ps2pdf run"+local'runno+"cont2_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"cont2_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"cont2_"+name(sfreq)+".ps)&"


      page division rows 1, columns 1
      open <ac over; kind graphic> file("run"+local'runno+"contrepo2"+name(grp)+"_"+name(sfreq)+".ps") as contaggrepo
      channel repo contaggrepo
      loop for i=1 to lastvalue(local'agelower) -- group loop
         -local'grpvar = string(local'agelower[i])+(if local'ageupper[i] eq 80 then "p" else ("t"+string(local'ageupper[i])))
         block 
            page frame appear off
            justify column heading right, contents right
            justify report center
            render font f10, cfont f10, dfont f10, points 8
            title font f10, points 8
            title #1 "Contributions"
            title #2 "(Ages "+local'grpvar+")"
            length full

            -local'nl = wildlist(local,"diffv^"+local'grpvar+name(sfreq)) union wildlist(local,"diffv^^"+local'grpvar+name(sfreq))
            -local'fl = wildnames(nl,"?f"+local'grpvar+"?")
            -local'ml = wildnames(nl,"?m"+local'grpvar+"?")
            set local'nl = local'nl except local'fl
            set local'nl = local'nl except local'ml

            type "NL = "+string(!nl)
            loop while length(local'nl) gt 0              
               -local'nl2 = selectnames(local'nl,nameloc(local'nl,@name) lt 15)
               set local'nl = local'nl except local'nl2

               repo 
                  loop for xx in nl2
                     select xx as description(xx)
                  end loop
                  print date (lout'end_est&"."&sfreq-60 to lout'end_est&"."&sfreq)
               end repo
            end loop

         end block
      end loop

      channel repo output      
      close contaggrepo
      execute "!(ps2pdf run"+local'runno+"contrepo2"+name(grp)+"_"+name(sfreq)+".ps; "+&&
                "gv run"+local'runno+"contrepo2"+name(grp)+"_"+name(sfreq)+".ps; "+&&
                "rm -f run"+local'runno+"contrepo2"+name(grp)+"_"+name(sfreq)+".ps)&"


      page division rows 2, column 1
      legend size xsmall

   end loop

   if local'loutopened
      close lout
   end if

   if local'cpsrevopened
      close cpsrev
   end if

   if local'linopened
      close lfprin
   end if

end block
end procedure
